use strict;
use warnings;
use Test::More;

use Sim::AgentSoar::Search;
use Sim::AgentSoar::Worker;

my $worker = Sim::AgentSoar::Worker->new(
    model => 'llama3.2:1b',
);

my $search = Sim::AgentSoar::Search->new(
    worker => $worker,
    branching_factor => 2,
    regression_tolerance => 2,
);

my $path = $search->run(start => 4, target => 19);

ok(defined $path, "Search returns a path");

done_testing;
